#ifndef __MT_FILE_H__
#define __MT_FILE_H__

#include "IDataStream.h"
#include "IFileStream.h"
#include "MTUtilities.h"

enum
{
	kFileEntryFlagHasParser = 	1 << 0,
	kFileEntryFlagHasEditor =	1 << 1,
	kFileEntryFlagNoData =		1 << 2
};

struct FileEntry
{
	UInt32		type;
	UInt32		start;
	UInt32		size;
	UInt32		nameOffset;
	UInt32		flags;
	
	UInt32		id;
	UInt32		localFlags;
	
	std::string	name;
};

class MTFile
{
	public:
						MTFile();
						~MTFile();
		
		void			LoadFile(FSSpec * theFile);
		
		void			ExportFile(UInt32 offset, UInt32 size);
		void			ExportFileByIdx(UInt32 idx);
		void			ImportFileByIdx(UInt32 idx);
		UInt8 *			LoadFileByIdx(UInt32 idx);
		void			ExportFileByID(UInt32 id);
		UInt8 *			LoadFileByID(UInt32 id);
		UInt8 *			LoadBase(UInt32 offset, UInt32 size);
		IFileStream *	OpenBaseFile(void);
		
		void			ExportSegment(UInt32 offset, UInt32 size);
		UInt8 *			LoadSegment(UInt32 offset, UInt32 size);
		IFileStream *	OpenDataFile(void);
		
		void			ExportRaw(UInt32 offset, UInt32 size);
		UInt8 *			LoadRaw(UInt32 offset, UInt32 size);
		IFileStream *	OpenRawFile(void);
		
		UInt32			LookupIdxFromID(UInt32 id);
		
		void			Clear(void);
		
		void			CopyToFile(IDataStream * in, IDataStream * out, UInt32 size);
		
		void			TextDump(void);
		
		UInt32		nameTableOffset;
		UInt32		fileDataOffset;
		UInt32		fileListElements;
		UInt32		nameListElements;
		
		std::vector <FileEntry>	fileList;
		
		FSSpec		baseFile;
		FSSpec		dataFile;
		FSSpec		rawFile;
	
	private:
		void	ParseHeader(IDataStream * stream);
		void	ParseFileList(IDataStream * stream);
		
		void	ParseFile(UInt32 idx);
		
		void	BuildOtherFiles(void);
};

#endif /* __MT_FILE_H__ */